// include the library code:
#include <NewPing.h>  // knihovna ultrazvuku

#define TRIGGER_PIN  2  // Arduino pin tied to trigger pin on ping sensor.
#define ECHO_PIN     3  // Arduino pin tied to echo pin on ping sensor.
#define MAX_DISTANCE 500 // Maximum distance we want to ping for (in centimeters). Maximum sensor distance is rated at 400-500cm.

NewPing sonar(TRIGGER_PIN, ECHO_PIN, MAX_DISTANCE); // NewPing setup of pins and maximum distance.

unsigned int pingSpeed = 50;  // How frequently are we going to send out a ping (in milliseconds). 50ms would be 20 times a second.
unsigned long pingTimer = 75; // Holds the next ping time, start at 75ms to give time for the Arduino pins to stabilize.

// initialize the library with the numbers of the interface pins

void setup() {
  // set up the LCD's number of columns and rows: 
   Serial.begin(9600);  
}

void loop() {
   
    if (millis() >= pingTimer) { // pingSpeed milliseconds since last ping, do another ping.
    pingTimer += pingSpeed;    // Set the next ping time.
   // Serial.print("Ping: ");
    int cm = sonar.ping_cm();  // Send out the ping, get the results in centimeters.
    Serial.print(cm);
    Serial.println(" cm");

   
  }
}


