// Pro prevod ceskych znaku v HTML kodu
// do zakladniho ASCII jsem pouzil prevod
// do formatu HEX NCR na webu:
// https://r12a.github.io/app-conversion/

static const char PROGMEM html[] = R"html(
<!DOCTYPE html>
<html lang="cs">
<head>
<title>WiFiRele</title>
<link href="https://fonts.googleapis.com/css?family=Comfortaa&amp;subset=latin-ext" rel="stylesheet">
<script
  src="https://code.jquery.com/jquery-3.3.1.min.js"
  integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
  crossorigin="anonymous">
</script>
<style>
body{
  font-family: "Comfortaa", cursive;
  line-height: 150%;
  margin: 50px;
  text-align: center;
}
a{
  display: inline-block;
  width: 100px;
  padding: 5px;
  border: 1px solid steelblue;
  font-weight: bold;
}
a:link, a:visited, a:active{
  color: steelblue;
  background: white;
  text-decoration: none;
}
a:hover{
  color: white;
  background: steelblue;
  text-decoration: none;
}
</style>
<script>
// Tato funkce se zpracuje pote, co se stahne a vykresli cely HTML kod
$(function(){
  // Na zacatku si pres AJAX stahni JSON s informacemi
  $.get("/api?data=1", function(data){
    if(data.odpoved == 1){
      console.log(data);
      // Aktualizuj podle stazenych dat prvky na strance
      $("#cas").html(data.cas);
      $("#ram").html(data.ram);
      $("#letni_cas").html(data.letni_cas);
      $("#zacatek").val(data.zacatek);
      $("#konec").val(data.konec);
      // Podle stavu rele vykresli adekvatni tlacitko
      if(data.stav == 1){
        $("#rozsvitit").hide();
        $("#stav").html("&nbsp;sepnuto");
        $("#stav").css("color", "green");
      }
      else{
        $("#zhasnout").hide();
        $("#stav").html("&nbsp;je vypnuto");
        $("#stav").css("color", "red");
      }
            // Podle stavu letniho casu vykresli adekvatni tlacitko
      if(data.letni_cas == 1){
        $("#zapni_letni").hide();
       }
      else{
        $("#vypni_letni").hide();
       }
    }
    else{
      console.error("Chyba: " + data.odpoved);
    }
  });
  // Pokud klepnu na tlacitko nastaveni casu, odesli AJAXem nove casy automatickeho spinani
  $("#nastavit").click(function(){
    $.get("/api?zacatek=" + $("#zacatek").val() + "&konec=" + $("#konec").val(), function(data){
      if(data.odpoved == 1){
        console.log("Zmena casu automatickeho spinani a vypinani");
      }
      else{
        console.error("Chyba: " + data.odpoved);
      }
    });
  });
  // Po klepnuti na odkaz pro rozsviceni odesli AJAXem prikaz k rozsviceni
  $("#rozsvitit").click(function(){
    $.get("/api?stav=1", function(data){
      if(data.odpoved == 1){
        console.log("Rele sepnuto!");
        $("#rozsvitit").hide();
        $("#zhasnout").show();
        $("#stav").html("&nbsp;zapnuto");
        $("#stav").css("color", "green");
      }
      else{
        console.error("Chyba: " + data.odpoved);
      }
    });
  });
  // Po klepnuti na odkaz pro zhasnuti odesli AJAXem prikaz ke zhasnuti
  $("#zhasnout").click(function(){
    $.get("/api?stav=0", function(data){
      if(data.odpoved == 0){
        console.log("Rele vypnuto!");
        $("#rozsvitit").show();
        $("#zhasnout").hide();
        $("#stav").html("&nbsp;je vypnuto");
        $("#stav").css("color", "red");
      }
      else{
        console.error("Chyba: " + data.odpoved);
      }
    });
  });

});

</script>
</head>
<body>
<h1>Rel&#x00E9;<span id="stav"></span></h1>
<p>
  <a id="rozsvitit" href="#">Zapnout</a>
  <a id="zhasnout" href="#">Vypnout</a>
</p>
<p>
  Nastavit &#x010D;as automatick&#x00E9;ho sp&#x00ED;n&#x00E1;n&#x00ED; a vyp&#x00ED;n&#x00E1;n&#x00ED;
</p>
<p>
  Zapnout v <input id="zacatek" type="time" /> a vypnout v 
  <input id="konec" type="time" />
  <input id="nastavit" type="button" value="Nastavit cas" />
</p>
<p>
  Aktu&#x00E1;ln&#x00ED; &#x010D;as: <span id="cas"></span>
  <a id="zapni_letni" href="/api?letnicas=1">Nastav letn&#x00ED; &#x010D;as</a>
  <a id="vypni_letni" href="/api?letnicas=0">Nastav zimn&#x00ED; &#x010D;as</a><br>
, voln&#x00E1; pam&#x011B;&#x0165;: <span id="ram"></span> kB
</p>
</body>
</html>
)html"; 
