// Knihovny pro praci s WiFi
#include <ESP8266WiFi.h>
#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include <WiFiManager.h> // Dohledate ve spravci knihoven
#include <Ticker.h>
#include <EEPROM.h>
#include <TimeLib.h> // https://github.com/PaulStoffregen/Time
#include <WiFiUdp.h>


#include "html.h" // HTML kod ovladaci stranky

// Cisla pinu LED, spinace a tlačítka
#define GPIO_LED 13
#define GPIO_TL 0
#define GPIO_RELE 12

// Webovy server pojede na standardnim portu 80
ESP8266WebServer server(80);

// Objekt ticker z vestavene knihovny se postara o blikani LED
Ticker ticker;


int signalstate = 1;
int signalstatelast = 1;

// Pomocne promenne pro synchronizaci casu
const char ntp_server[] = "tik.cesnet.cz";
uint8_t zona = 1 ;  
uint8_t zonanew ;  
const uint8_t port = 8888;
uint8_t ntp_packet[48];
WiFiUDP Udp;

// Kontrolni promenna pro spinani podle casoveho planu
uint64_t kontrola_spinace = 0;

// Hodiny a minuty spinani podle casoveho planu
uint8_t zacatek_hodina, zacatek_minuta, konec_hodina, konec_minuta, letni_cas;

// Funkce tick rozsviti/zhasne LED
void tick() {
  digitalWrite(GPIO_LED, !digitalRead(GPIO_LED));
}

// Pokud se cip nemuze pripojit k Wi-Fi a spustil vlastni konfiguracni AP, rozblikej LED
void zacatekKonfigurace(WiFiManager *wmp) {
  // kazdych 200 ms zavolej funkci tick
  ticker.attach(0.2, tick);
}

// Jakmile rezim konfigurace Wi-Fi skonci, ukonci blikani
// LED na Sonoff Basic ma opacnou logiku
// Pri LOW sviti a pri HIGH je zhasnuta
void konecKonfigurace() {
  ticker.detach();
  digitalWrite(GPIO_LED, HIGH);
}

// Halvni funkce, ktera se zpracuje po startu
void setup() {
  // Nastaveni smeru pinu GPIO na zapis
  pinMode(GPIO_LED, OUTPUT);
  pinMode(GPIO_RELE, OUTPUT);
  pinMode(GPIO_TL, INPUT);
  
  // Zhasni LED
  digitalWrite(GPIO_LED, HIGH);
  Serial.begin(115200);
  // Precti prvni 4 B z trvale pameti,
  // ve ktere jsou ulozene casy automatickeho spinani a vypinani
  EEPROM.begin(5);
  zacatek_hodina = EEPROM.read(0);
  zacatek_minuta = EEPROM.read(1);
  konec_hodina = EEPROM.read(2);
  konec_minuta = EEPROM.read(3);
  letni_cas = EEPROM.read(4);

  // Nastartuj WiFiManager, ktery se postara o pripojeni k Wi-Fi
  WiFiManager wm;
  wm.setAPCallback(zacatekKonfigurace);
  wm.setSaveConfigCallback(konecKonfigurace);
  // IP parametry konfiguracni Wi-Fi site
  wm.setAPStaticIPConfig(IPAddress(192, 168, 100, 1), IPAddress(192, 168, 100, 1), IPAddress(255, 255, 255, 0));

  // Pripoj se k Wi-Fi
  // Pokud zatim zadnou nemas v pameti, nebo je mimo dosah,
  // spust vlastni AP, ke kteremu se muze uzivatel pripojit a nastavit novou Wi-Fi
  if (!wm.autoConnect("WiFiSonoff","Sonoff18")) {
    // Pokud se neco pokazi a nelze se pripojit, restartuj cip a zacni znovu
    ESP.reset();
    delay(1000);
  }
  else {
    Serial.print("Pripojen jako: ");
    Serial.println(WiFi.localIP());
  }

  // Ted uz jsem pripojeny k Wi-Fi, takze mohu pokracovat v programu
  // Pokud uzivatel zada do prohlizece IP adresu spinace,
  // posli mu HTML kod ulozeny v souboru html.h.
  // Behem HTTP komunikace zaroven sviti LED (problikne)
  // HTML kod se nacita primo z flashove pameti cipu a nezatezuje RAM
  server.on("/", []() {
    digitalWrite(GPIO_LED, LOW);
    server.send_P(200, "text/html", html);
    digitalWrite(GPIO_LED, HIGH);
  });

  // Server zaroven reaguje na nekolik HTTP dotazu ve formatu:
  // http://ipadresa/api?PARAMETR=HODNOTA
  // Pro nastaveni automatickeho spinani a vypinani tedy staci zavolat:
  // http://ipadresa/api?zacatek=HH:MM&konec=HH:MM
  server.on("/api", []() {
    digitalWrite(GPIO_LED, LOW);
    if (server.hasArg("zacatek") && server.hasArg("konec")) {
      if ((server.arg("zacatek") != NULL) && (server.arg("konec") != NULL)) {
        zacatek_hodina = server.arg("zacatek").substring(0, 2).toInt();
        zacatek_minuta = server.arg("zacatek").substring(3, 5).toInt();
        konec_hodina = server.arg("konec").substring(0, 2).toInt();
        konec_minuta = server.arg("konec").substring(3, 5).toInt();
        EEPROM.write(0, zacatek_hodina);
        EEPROM.write(1, zacatek_minuta);
        EEPROM.write(2, konec_hodina);
        EEPROM.write(3, konec_minuta);
        EEPROM.commit();
        server.send(200, "application/json", "{\"odpoved\":\"1\"}");
      }
      else {
        server.send(200, "application/json", "{\"odpoved\":\"0\"}");
      }
    }
    // Pro sepnuti rele (zapnuti/vypnuti svetla):
    // http://ipadresa/api?stav=1 (nebo 0)
    else if (server.hasArg("stav")) {
      if (server.arg("stav") != NULL) {
        uint8_t stav = server.arg("stav").toInt();
        if (stav == 1) {
          Serial.println("Zapinam rele");
          digitalWrite(GPIO_RELE, HIGH);
          server.send(200, "application/json", "{\"odpoved\":\"1\"}");
        }
        else {
          Serial.println("Vypinam rele");
          digitalWrite(GPIO_RELE, LOW);
          server.send(200, "application/json", "{\"odpoved\":\"0\"}");
        }
      }
      else {
        server.send(200, "application/json", "{\"odpoved\":\"-1\"}");
      }
    }

    // pro načteni dat do serveru o stavu:
    // http://ipadresa/api?precti_data=1 
    // vrací data stav_rele|letnicas*|*
    
    else if (server.hasArg("prectidata")) {
      Serial.println("Pozadavek na cteni dat");
      String webString = "";
      webString = "" + String(digitalRead(GPIO_RELE)) + "|"+ String(EEPROM.read(4)) +"*|*"; 
      server.send(200, "text/plain", webString);   
    }
    
    // Pro nastaveni letniho casu
    // http://ipadresa/api?letnicas=1 (nebo 0)
    else if (server.hasArg("letnicas")) {
      if (server.arg("letnicas") != NULL) {
        uint8_t stav = server.arg("letnicas").toInt();
        if (stav == 1) {
          Serial.println("Zapinam letni cas");
           EEPROM.write(4, 1);
           EEPROM.commit();
           // aby se zona projevila bez nutnosti restartovat obvod
            setSyncProvider(ziskejNtpCas);
          //  server.send(200, "application/json", "{\"odpoved\":\"1\"}");
       // přesmeruj na hlavni stránku aby se rovnouo aktualizoval datum na stránce
        
        server.sendHeader("Location", String("/"), true);
        server.send ( 302, "text/plain", "");
        }
        else {
          Serial.println("Vypinam letni cas");
          EEPROM.write(4, 0);
          EEPROM.commit();
           // aby se zona obnovila bez nutnosti restartovat obvod 
            setSyncProvider(ziskejNtpCas);
         // server.send(200, "application/json", "{\"odpoved\":\"0\"}");
        // přesmeruj na hlavni stránku aby se rovnouo aktualizoval datum na stránce
        
        server.sendHeader("Location", String("/"), true);
        server.send ( 302, "text/plain", "");
        
        }
      }
      else {
        server.send(200, "application/json", "{\"odpoved\":\"-1\"}");
      }
    }
    // Pro stazeni udaju (teplota, stav, cas na cipu, volna RAM) v JSON:
    // http://ipadresa/api?data=
    else if (server.hasArg("data")) {
      String data = "{\"odpoved\":\"1\", \"zacatek\":\"#zacatek\", \"konec\":\"#konec\", \"stav\":\"#stav\", \"cas\":\"#cas\", \"ram\":\"#ram\", \"letni_cas\":\"#letni_cas\"}";
      char zacatek[6];
      char konec[6];
      char cas[9];
   //   sensors.requestTemperatures();
      sprintf(zacatek, "%02d:%02d", zacatek_hodina, zacatek_minuta);
      sprintf(konec, "%02d:%02d", konec_hodina, konec_minuta);
      sprintf(cas, "%02d:%02d:%02d", hour(), minute(), second());

      // Nahrad hodnoty v AJAX sablone vyse 
      // S tridou Arduino String zachazet s velkou rozvahou, pouziva dynamickou alokaci
      // Na cipech s malickou RAM ji mohou pri spatnem designu rychle zaplnit
      // Viz pamet typu heap, dynamicka alokace a riziko fragmentace RAM
      // https://www.gribblelab.org/CBootCamp/7_Memory_Stack_vs_Heap.html
      data.replace("#stav", String(digitalRead(GPIO_RELE)));
      data.replace("#zacatek", String(zacatek));
      data.replace("#konec", String(konec));
      data.replace("#cas", String(cas));
      data.replace("#ram", String((ESP.getFreeHeap() / 1000.0f), 2));
      data.replace("#letni_cas", String(letni_cas));
      server.send(200, "application/json", data);
    }
    else {
      server.send(200, "application/json", "{\"odpoved\":\"0\"}");
    }
    digitalWrite(GPIO_LED, HIGH);
  });

  // Nastartovani UDP (synchronizace casu pomoci NTP serveru)
  Udp.begin(port);
  // Knihovna pro praci s casem bude kazdou hodinu
  // volat funkci, ktera bude stahovat cerstvy cas z NTP serveru
  setSyncProvider(ziskejNtpCas);
  setSyncInterval(3600);

  // Nastartovani HTTP serveru
  server.begin();

}

// Smycka loop se opakuje stale dokola
void loop() {
  // Zpracuj pozadavky HTTP klientu
  server.handleClient();


 

  // Jednou za minutu zkontroluj, jestli aktualni
  // cas neodpovida hodnotam pro automaticke sepnuti/vypnuti rele
  if (millis() > kontrola_spinace) {
    if ((zacatek_hodina == hour()) && (zacatek_minuta == minute())) {
      digitalWrite(GPIO_RELE, HIGH);
      Serial.println("Spinam rele podle casoveho planu");
    }
    if ((konec_hodina == hour()) && (konec_minuta == minute())) {
      digitalWrite(GPIO_RELE, LOW);
      Serial.println("Vypinam rele podle casoveho planu");
    }
    kontrola_spinace = millis() + 6e4;
  }

  

if (digitalRead(GPIO_RELE) == LOW) {
// zde je opačná logika pokud je relé rozpojeno je nutné poslat HIGH aby dioda zhasla 


  digitalWrite(GPIO_LED, HIGH);
  
}else{

  digitalWrite(GPIO_LED, LOW); 
}
  

      

 
  // přečteme signál z tlačítka
  signalstate = digitalRead(GPIO_TL);

if (signalstate != signalstatelast) {

if (signalstate == LOW){
  

        if (digitalRead(GPIO_RELE) == LOW) {

           digitalWrite(GPIO_RELE, HIGH); 
           Serial.println("zapinam rele tlacitkem ");
          }else{

          digitalWrite(GPIO_RELE, LOW);  
            Serial.println("vypinam rele tlacitkem");
            
          }
          
 
      delay(50);
         
   } 
}
  signalstatelast = signalstate;  

    
      
  /*    pocitadlo++;
      Serial.println("on");
      Serial.print("number of button pushes: ");
      Serial.println(pocitadlo);
    } else {
      // if the current state is LOW then the button went from on to off:
      Serial.println("off");
    }
    // Delay a little bit to avoid bouncing
    delay(50);
  }
*/


}

// Funcke pro ziskani aktualniho casu z NTP serveru skrze UDP protokol
time_t ziskejNtpCas()
{
   letni_cas = EEPROM.read(4);
   zonanew = zona + letni_cas;
  Serial.println("aktualizuji cas");
   
  IPAddress ntp_server_ip;
  while (Udp.parsePacket() > 0);
  WiFi.hostByName(ntp_server, ntp_server_ip);
  odesliNtpPacket(ntp_server_ip);
  uint32_t start = millis();
  while (millis() - start < 1500) {
    int size = Udp.parsePacket();
    if (size >= 48) {
      Udp.read(ntp_packet, 48);
      unsigned long sekundy; // sekundy od roku 1900
      sekundy =  (unsigned long)ntp_packet[40] << 24;
      sekundy |= (unsigned long)ntp_packet[41] << 16;
      sekundy |= (unsigned long)ntp_packet[42] << 8;
      sekundy |= (unsigned long)ntp_packet[43];
      // Vrati pocet sekund a pripocita casovou zonu
      return sekundy - 2208988800UL + zonanew * SECS_PER_HOUR;
    }
  }
  // Pokud se dotaz nepodaril, vrat 0
  return 0;
}

// Funcke pro odeslani UDP paketu/framu na NTP server
void odesliNtpPacket(IPAddress &adresa) {
  memset(ntp_packet, 0, 48);
  ntp_packet[0]  = 0b11100011;
  ntp_packet[1]  = 0;
  ntp_packet[2]  = 6;
  ntp_packet[3]  = 0xEC;
  ntp_packet[12] = 49;
  ntp_packet[13] = 0x4E;
  ntp_packet[14] = 49;
  ntp_packet[15] = 52;
  Udp.beginPacket(adresa, 123);
  Udp.write(ntp_packet, 48);
  Udp.endPacket();
}
